﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Microsoft.Extensions.DependencyInjection" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.SrodkiTrwale" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
		<title>Wartości środków trwałych</title>
		
		<meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
		<meta name="CODE_LANGUAGE" Content="C#">
		<meta name="vs_defaultClientScript" content="JavaScript">
		<meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
		<script runat="server">
			SrodkiTrwale.Params p = null;
			Soneta.Types.DictionaryAuto<OddzialProxy, System.Collections.Generic.List<Item>> wgOddzialow = new DictionaryAuto<OddzialProxy, System.Collections.Generic.List<Item>>();
			
			void DataRepeater1_BeforeRow(object sender, EventArgs args) {
				OddzialProxy odd = (OddzialProxy)((DataRepeater)sender).CurrentRow;
				DataLabelOddzial.EditValue = odd.Oddzial == null ? "" : odd.Oddzial.ToString();

				wgOddzialow[odd].Sort(ComapreItems);
				if (param.WgGrup) {
					System.Collections.Generic.Dictionary<string, GrupaItem> wgGrup = new System.Collections.Generic.Dictionary<string, GrupaItem>();
					foreach (SrodekItem si in wgOddzialow[odd]) {
						if(!wgGrup.ContainsKey(si.Grupa))
							wgGrup.Add(si.Grupa,new GrupaItem(si.Grupa));
						wgGrup[si.Grupa].Add(si);
					}
					if (Grid1.Columns.Contains(colNazwa)) {
						Grid1.ShowGroupSum = false;
						Grid1.GroupLine = "";
						Grid1.GroupData0 = "";
						colSymbol.Caption = "Grupa";
						colSymbol.RowSpan = prm.TylkoWartosciBilansowe ? 1 : 2;
						colSymbol.Width = 10;
						Grid1.Columns.Remove(colNazwa);
                        Grid1.Columns.Remove(colUzytkowanie);
						Grid1.Columns.Remove(colLikwidacja);
					}
					Grid1.DataSource = wgGrup.Values;
				}
				else
					Grid1.DataSource = new ArrayList( wgOddzialow[odd]);
			}	
		
      void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
      }

      void WartosciSrodkowTrwalych_OnLoad(Object sender, EventArgs args){
        p     = (SrodkiTrwale.Params)DataContext1.Get(typeof(SrodkiTrwale.Params));

		ReportHeader1.Title = "Wartości środków trwałych" + p.GetReportParametersDescription();

		  if(param.WgOddzialow)
          ReportHeader1.Title +=  string.Format("|</STRONG>Oddział:<STRONG> {0}",
            param.OddzialItem.type==OddziałItemType.RazemDostępne ? "Razem dostępne" : param.OddzialItem.Kod);
				OddzialProxy oddNull = new OddzialProxy(null);

				foreach (SrodekTrwalyBase s in (Row[])DataContext1.Get(typeof(Row[]))) {
					SrodekTrwalyBaseHistoria sh = s[p.Aktualnosc];
					if (s.DataRejestracji == Date.Empty || s.DataRejestracji > p.Aktualnosc)
						continue;
					OddzialFirmy o = (!param.WgOddzialow || sh.MiejsceUzytkowania==null)? null : sh.MiejsceUzytkowania.Oddzial;
					OddzialProxy odd = null;
					if(o==null)
						odd = oddNull;
					else
						odd = new OddzialProxy(o);

          Date aktualnoscBO = p.Aktualnosc.FirstDayYear();
          SrodekTrwalyBaseHistoria shbo = s[aktualnoscBO];
          OddzialFirmy obo = (!param.WgOddzialow || shbo.MiejsceUzytkowania == null) ? null : shbo.MiejsceUzytkowania.Oddzial;
          OddzialProxy oddbo = null;
          if (obo == null)
            oddbo = oddNull;
          else
            oddbo = new OddzialProxy(obo);

          if (!param.ZeZmianamiMiescjaUzytkowania || obo == o) {
            if(param.CheckOddzial(odd))
              wgOddzialow[odd].Add(new SrodekItem(sh, p.Aktualnosc,null,false));
          } else {
            SrodekItem sibo = new SrodekItem(shbo, aktualnoscBO,null,true);
            if (param.CheckOddzial(oddbo))            
              wgOddzialow[oddbo].Add(sibo);
            if (param.CheckOddzial(odd))
              wgOddzialow[odd].Add(new SrodekItem(sh, p.Aktualnosc,sibo,false));
          }
				}


				FromTo okres = new FromTo(new Date(p.Aktualnosc.Year, 1, 1), new Date(p.Aktualnosc.Year, 12, 31));
				if (SrodkiTrwaleModule.GetInstance(p).Config.Ogólne.UwzględniajKontekstOkresuObrach)
				{
					var oos = p.Session.GetService(typeof(IOkresObrachunkowyService)) as IOkresObrachunkowyService;
					if (oos != null)
						okres = oos.OkresWgDaty(p.Aktualnosc);
				}

				String okresPoczatekStr = okres.From.ToString("dd.MM.yy");
				colWartosc01B.Caption = String.Format("Wartość na {0} (B)", okresPoczatekStr);
				colWartosc01P.Caption = String.Format("Wartość na {0} (P)", okresPoczatekStr);
				colOdpisy01B.Caption = String.Format("Umorzenie na {0} (B)", okresPoczatekStr);
				colOdpisy01P.Caption = String.Format("Umorzenie na {0} (P)", okresPoczatekStr);
		  		  
		  
				DataRepeater1.DataContext = DataContext1;
				DataRepeater1.DataSource = wgOddzialow.Keys;

		  	
		  
				if (prm.TylkoWartosciBilansowe)
				{
					Grid1.RowsInRow = 1;
					colSymbol.Width = 0;
					colUzytkowanie.Visible = false;
					colLikwidacja.Visible = false;
					colWartoscPoczatkowaP.Visible=false;
					colWartosc01P.Visible=false;
					colZwiekszeniaWartoscP.Visible=false;
					colZmniejszeniaWartoscP.Visible=false;
					colWartoscP.Visible=false;
					colOdpisyAktualizujaceP.Visible=false;
					colOdpisy01P.Visible=false;
					colZwiekszeniaOdpisyP.Visible=false;
					colZmniejszeniaOdpisyP.Visible=false;
					colOdpisyP.Visible=false;
					colWartoscNettoP.Visible=false;
				}
      }
		




			public class OddzialProxy {
				readonly public OddzialFirmy Oddzial;
				public OddzialProxy(OddzialFirmy oddzial) {
					Oddzial = oddzial;
				}

				public override int GetHashCode() {
					return (Oddzial==null) ? base.GetHashCode() : Oddzial.GetHashCode();
				}

				public override bool Equals(object obj) {
					OddzialProxy op = (OddzialProxy)obj;
					return op.Oddzial == this.Oddzial;
				}
			}
		
			int ComapreItems(Item x, Item y){
				int ret = string.Compare(x.Grupa, y.Grupa);
				if (ret != 0)
					return ret;
				return string.Compare(x.Symbol, y.Symbol);
			}	
						

			abstract public class Item {
				public Item(string symbol, string nazwa, string grupa) {
					this.symbol = symbol;
					this.nazwa = nazwa;
					this.grupa = grupa;
				}

                public Item(string symbol, string nazwa, string grupa, Date rejestracja, Date uzytkowanie, Date likwidacja)
                {
					this.symbol = symbol;
					this.nazwa = nazwa;
					this.grupa = grupa;
					this.rejestracja = rejestracja;
                    this.uzytkowanie = uzytkowanie;
					this.likwidacja = likwidacja;
				}				
				
				protected readonly string symbol;
				public string Symbol {
					get { return symbol; }
				}

				protected readonly string nazwa;
				public string Nazwa {
					get { return nazwa; }
				}

				protected readonly string grupa;
				public string Grupa {
					get { return grupa; }
				}



				protected readonly Date rejestracja;
				public Date Rejestracja {
					get { return rejestracja; }
				}
                protected readonly Date uzytkowanie;
                public Date Uzytkowanie{
                    get { return uzytkowanie; }
				}
                
				protected readonly Date likwidacja;
				public Date Likwidacja {
					get { return likwidacja; }
				}

				protected decimal wartoscPoczatkowaB;
				public decimal WartoscPoczatkowaB {
					get { return wartoscPoczatkowaB; }
				}

				protected decimal wartoscPoczatkowaP;
				public decimal WartoscPoczatkowaP {
					get { return wartoscPoczatkowaP; }
				}

				protected decimal wartoscBrutto01B;
				public decimal WartoscBrutto01B {
					get { return wartoscBrutto01B; }
				}

				protected decimal wartoscBrutto01P;
				public decimal WartoscBrutto01P {
					get { return wartoscBrutto01P; }
				}

				protected decimal wartoscBruttoZwiekszeniaB;
				public decimal WartoscBruttoZwiekszeniaB {
						get { return wartoscBruttoZwiekszeniaB; }
				}

				protected decimal wartoscBruttoZwiekszeniaP;
				public decimal WartoscBruttoZwiekszeniaP {
					get { return wartoscBruttoZwiekszeniaP; }
				}

				protected decimal wartoscBruttoZmniejszeniaB;
				public decimal WartoscBruttoZmniejszeniaB {
						get { return wartoscBruttoZmniejszeniaB; }
				}

				protected decimal wartoscBruttoZmniejszeniaP;
				public decimal WartoscBruttoZmniejszeniaP {
						get { return wartoscBruttoZmniejszeniaP; }
				}                    

				protected decimal wartoscBruttoB;
				public decimal WartoscBruttoB {
						get { return wartoscBruttoB; }
				}

				protected decimal wartoscBruttoP;
				public decimal WartoscBruttoP {
						get { return wartoscBruttoP; }
				}          
		
				protected decimal odpisyAktualizujaceB;
				public decimal OdpisyAktualizujaceB {
					get { return odpisyAktualizujaceB; }
				}

				protected decimal odpisyAktualizujaceP;
				public decimal OdpisyAktualizujaceP {
					get { return odpisyAktualizujaceP; }
				}


				protected decimal odpisy01B;
				public decimal Odpisy01B {
					get { return odpisy01B; }
				}

				protected decimal odpisy01P;
				public decimal Odpisy01P {
					get { return odpisy01P; }
				}

				protected decimal odpisyZwiekszeniaB;
				public decimal OdpisyZwiekszeniaB {
					get { return odpisyZwiekszeniaB; }
				}

				protected decimal odpisyZwiekszeniaP;
				public decimal OdpisyZwiekszeniaP {
						get { return odpisyZwiekszeniaP; }
				}

				protected decimal odpisyZmniejszeniaB;
				public decimal OdpisyZmniejszeniaB {
						get { return odpisyZmniejszeniaB; }
				}

				protected decimal odpisyZmniejszeniaP;
				public decimal OdpisyZmniejszeniaP {
						get { return odpisyZmniejszeniaP; }
				}                              

				protected decimal odpisyB;
				public decimal OdpisyB {
					get { return odpisyB; }
				}

				protected decimal odpisyP;
				public decimal OdpisyP {
					get { return odpisyP; }
				}

				protected decimal wartoscNettoB;
				public decimal WartoscNettoB {
					get { return wartoscNettoB; }
				}

				protected decimal wartoscNettoP;
				public decimal WartoscNettoP {
					get { return wartoscNettoP; }
				}				
			}



			public class SrodekItem : Item 
			{
				public SrodekItem(SrodekTrwalyBaseHistoria sh, Date aktualnosc,SrodekItem bo, bool liczTylkoBO)
					: base(sh.Srodek.NumerInwentarzowy,sh.Srodek.Nazwa,sh.KRST.GrupaSymbol, sh.Srodek.DataRejestracji, sh.Srodek.DataRozpoczeciaUzytkowania, sh.Srodek.DataLikwidacji) 
			
			{
					WartosciSrodkaWorker wsw = SrodekItem.WSW;
					wsw.Data = aktualnosc;
					wsw.SrodekHistoria = sh;

					if (liczTylkoBO) 
					{
							wartoscPoczatkowaB = wsw.WartoscPoczatkowaBilansowa.Value;
							wartoscPoczatkowaP = wsw.WartoscPoczatkowaPodatkowa.Value;
							wartoscBrutto01B = wsw.Wartosc01Bilansowa.Value;
							wartoscBrutto01P = wsw.Wartosc01Podatkowa.Value;
							odpisy01B = wsw.Odpisy01Bilansowe.Value;
							odpisy01P = wsw.Odpisy01PodatkoweZUlgami.Value;
							wartoscBruttoZmniejszeniaB = -wartoscBrutto01B;
							wartoscBruttoZmniejszeniaP = -wartoscBrutto01P;
							odpisyZmniejszeniaB = -odpisy01B;
							odpisyZmniejszeniaP = -odpisy01P;                     
					 } 
					else
					{
							wartoscPoczatkowaB = bo==null ? wsw.WartoscPoczatkowaBilansowa.Value : 0m;
							wartoscPoczatkowaP = bo==null ? wsw.WartoscPoczatkowaPodatkowa.Value : 0m;
							wartoscBrutto01B = bo==null ? wsw.Wartosc01Bilansowa.Value : 0m;
							wartoscBrutto01P = bo==null ? wsw.Wartosc01Podatkowa.Value : 0m;
							wartoscBruttoZwiekszeniaB = wsw.WartoscBilansowaZwiekszeniaBiezace.Value;
							wartoscBruttoZwiekszeniaP = wsw.WartoscPodatkowaZwiekszeniaBiezace.Value;
							if (bo != null) 
							{
							  wartoscBruttoZwiekszeniaB += -bo.WartoscBruttoZmniejszeniaB;
							  wartoscBruttoZwiekszeniaP += -bo.WartoscBruttoZmniejszeniaP;
							}
							wartoscBruttoZmniejszeniaB = wsw.WartoscBilansowaZmniejszeniaBiezace.Value;
							wartoscBruttoZmniejszeniaP = wsw.WartoscPodatkowaZmniejszeniaBiezace.Value;
							wartoscBruttoB = wsw.WartoscBilansowa.Value;
							wartoscBruttoP = wsw.WartoscPodatkowa.Value;

							odpisyAktualizujaceB = wsw.OdpisyAktualizująceBilansowe.Value;
							odpisyAktualizujaceP = wsw.OdpisyAktualizującePodatkowe.Value;
			
							odpisy01B =  bo==null ? wsw.Odpisy01Bilansowe.Value : 0m;
							odpisy01P =  bo==null ? wsw.Odpisy01PodatkoweZUlgami.Value : 0m;
							odpisyZwiekszeniaB = wsw.OdpisyBilansoweZwiekszeniaBiezace.Value;
							odpisyZwiekszeniaP = wsw.OdpisyPodatkoweZwiekszeniaZUlgamiBiezace.Value;
			
							if (bo != null)
							 {
							  odpisyZwiekszeniaB += -bo.OdpisyZmniejszeniaB;
							  odpisyZwiekszeniaP += -bo.OdpisyZmniejszeniaP;
							}
			            
							odpisyZmniejszeniaB = wsw.OdpisyBilansoweZmniejszeniaBiezace.Value;
							odpisyZmniejszeniaP = wsw.OdpisyPodatkoweZmniejszeniaBiezace.Value;
							odpisyB = wsw.OdpisyBilansowe.Value;
							odpisyP = wsw.OdpisyPodatkoweZUlgami.Value;
							wartoscNettoB = wsw.WartoscBilansowaNetto.Value;
							wartoscNettoP = wsw.WartoscPodatkowaNettoZUlgami.Value;
					 }
			
				}




				static WartosciSrodkaWorker wsw = null;
				static public WartosciSrodkaWorker WSW{
					get {
						lock(typeof(SrodekItem)){
						if (wsw != null)
							return wsw;
						wsw = new WartosciSrodkaWorker();
						}
						return wsw;
					}
				}
			}	
		
			public class GrupaItem : Item{
				public GrupaItem(string grupa)
					: base(grupa, grupa, grupa) {
				}
				
				internal void Add(SrodekItem si){
					wartoscPoczatkowaB += si.WartoscPoczatkowaB;
					wartoscPoczatkowaP += si.WartoscPoczatkowaP;
					wartoscBrutto01B += si.WartoscBrutto01B;
					wartoscBrutto01P += si.WartoscBrutto01P;
					wartoscBruttoZwiekszeniaB += si.WartoscBruttoZwiekszeniaB;
					wartoscBruttoZwiekszeniaP += si.WartoscBruttoZwiekszeniaP;
					wartoscBruttoZmniejszeniaB += si.WartoscBruttoZmniejszeniaB;
					wartoscBruttoZmniejszeniaP += si.WartoscBruttoZmniejszeniaP;					
					wartoscBruttoB += si.WartoscBruttoB;
					wartoscBruttoP += si.WartoscBruttoP;
					odpisyAktualizujaceB += si.OdpisyAktualizujaceB;
					odpisyAktualizujaceP += si.OdpisyAktualizujaceP;
					odpisy01B += si.Odpisy01B;
					odpisy01P += si.Odpisy01P;
					odpisyZwiekszeniaB += si.OdpisyZwiekszeniaB;
					odpisyZwiekszeniaP += si.OdpisyZwiekszeniaP;
					odpisyZmniejszeniaB += si.OdpisyZmniejszeniaB;
					odpisyZmniejszeniaP += si.OdpisyZmniejszeniaP;					
					odpisyB += si.OdpisyB;
					odpisyP += si.OdpisyP;					
					wartoscNettoB += si.WartoscNettoB;
					wartoscNettoP += si.WartoscNettoP;					
				}
			}				

			Params param = null;
			[Context]	
			public Params Param {
				set { param = value; }
			}		

			public class Params : ContextBase {
        Soneta.Core.OddzialParamsBase oddzialParams = null;
        
				public Params(Context cx)
					: base(cx) {
          if (cx.Contains(typeof(Soneta.Core.OddzialParamsBase)))
            oddzialParams = (Soneta.Core.OddzialParamsBase)cx[typeof(Soneta.Core.OddzialParamsBase)];
          else
            oddzialParams = new OddzialParamsBase(cx);
          oddzialItem = oddzialParams.Oddział;
				}

        bool wgGrup = false;
				[Caption("Wg grup")]
				[Soneta.Tools.Priority(1)]
				public bool WgGrup {
					get { return wgGrup; }
					set { wgGrup = value; OnChanged(EventArgs.Empty); }
				}

        bool wgOddzialow = false;
        [Caption("Wg oddziałów")]
        [Soneta.Tools.Priority(202)]
        public bool WgOddzialow {
          get { return wgOddzialow; }
          set {
            wgOddzialow = zeZmianamiMiescjaUzytkowania = value;
            oddzialItem = oddzialParams.Oddział;
            OnChanged(EventArgs.Empty);
          }
        }

        public bool IsReadOnlyWgOddzialow() {
          return !oddzialParams.OddzialowoscEnabled;
        }                

        Soneta.Core.OddziałItem oddzialItem = null;
        [Soneta.Tools.Priority(203)]
        [Caption("Oddział")]        
        public Soneta.Core.OddziałItem OddzialItem {
          get { return oddzialItem; }
          set { oddzialItem = value; OnChanged(EventArgs.Empty); }
        }

        public object GetListOddzialItem() {
          System.Collections.Generic.List<OddziałItem> list = new System.Collections.Generic.List<OddziałItem>();
          foreach (OddziałItem oi in (IEnumerable)oddzialParams.GetListOddział())
            if (oi.type == OddziałItemType.Oddział || oi.type == OddziałItemType.RazemDostępne)
              list.Add(oi);
          return list;
        }

        public bool IsReadOnlyOddzialItem() {
          return !wgOddzialow;
        }        

        bool zeZmianamiMiescjaUzytkowania = false;
        [Caption("Zmiany miejsca użytk.")]
        [Soneta.Tools.Priority(204)]
        public bool ZeZmianamiMiescjaUzytkowania {
          get { return zeZmianamiMiescjaUzytkowania; }
          set { zeZmianamiMiescjaUzytkowania = value; OnChanged(EventArgs.Empty); }
        }

        public bool IsReadOnlyZeZmianamiMiescjaUzytkowania() {
          return !WgOddzialow;
        }
        
        public bool CheckOddzial(OddzialProxy proxy) {
          switch (oddzialItem.type) {
            case OddziałItemType.RazemDostępne:
              return true;
            case OddziałItemType.Oddział:
              return proxy.Oddzial!=null && proxy.Oddzial==(OddzialFirmy)oddzialItem.ptr;
            default:
              return false;
          }
        }            
			}



			
			#region TylkoWartosciBilansowePrm

			TylkoWartosciBilansowePrm prm = null;

			[Context]
			public TylkoWartosciBilansowePrm Prm
			{ set { prm = value; } }


			#endregion
		
		</script>
</HEAD>
	<body>
		<form id="WartosciSrodkowTrwalych" method="post" runat="server" onload="WartosciSrodkowTrwalych_OnLoad">
			<ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business"
				Landscape="True" BottomMargin="10" LeftMargin="10" RightMargin="10" 
        TopMargin="10" ></ea:DataContext><BR>
			<cc1:ReportHeader id="ReportHeader1" runat="server" ></cc1:ReportHeader><BR>
      <ea:DataRepeater id="DataRepeater1" runat="server" RowTypeName="Soneta.Core.OddzialFirmy,Soneta.Core" OnBeforeRow="DataRepeater1_BeforeRow">			
      <ea:DataLabel ID="DataLabelOddzial" runat="server"></ea:DataLabel>
			<ea:Grid id="Grid1" runat="server" RowTypeName="Item"
				OnBeforeRow="Grid1_BeforeRow"
				ShowGroupSum="True" GroupData0="Grupa"
				GroupLine="Grupa: {0}" Sort="Grupa,Symbol" RowsInRow="2">
<Columns>
<ea:GridColumn Width="25" id="colSymbol" DataMember="Symbol" Total="Info" EncodeHTML="true" Caption="Nr inwentarzowy" runat="server"></ea:GridColumn>
<ea:GridColumn Width="25" id="colNazwa" DataMember="Nazwa" Caption="Nazwa" EncodeHTML="true" runat="server"></ea:GridColumn>
<ea:GridColumn Visible = false Width="12" id="colUzytkowanie" Align="Center" DataMember="Uzytkowanie" Caption="Rozpoczęcie użytkowania" runat="server"></ea:GridColumn>
<ea:GridColumn Visible = false Width="12" id="colLikwidacja" Align="Center" DataMember="Likwidacja" Caption="Likwidacja" runat="server"></ea:GridColumn>
<ea:GridColumn Visible = false Align="Right" DataMember="WartoscPoczatkowaB" Total="Sum" Caption="Wartość początkowa (B)" Format="{0:n}" ID="colWartoscPoczatkowaB" runat="server" ></ea:GridColumn>
<ea:GridColumn Visible = false Align="Right" DataMember="WartoscPoczatkowaP" Total="Sum" Caption="Wartość początkowa (P)" Format="{0:n}" ID="colWartoscPoczatkowaP" runat="server" ></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscBrutto01B" Total="Sum" Caption="Wartość na 01.01.br (B)" Format="{0:n}" ID="colWartosc01B" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscBrutto01P" Total="Sum" Caption="Wartość na 01.01.br (P)" Format="{0:n}" ID="colWartosc01P" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscBruttoZwiekszeniaB" Total="Sum" Caption="Zwiększenia (B)" Format="{0:n}" ID="colZwiekszeniaWartoscB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscBruttoZwiekszeniaP" Total="Sum" Caption="Zwiększenia (P)" Format="{0:n}" ID="colZwiekszeniaWartoscP" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscBruttoZmniejszeniaB" Total="Sum" Caption="Zmniejszenia (B)" Format="{0:n}" ID="colZmniejszeniaWartoscB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscBruttoZmniejszeniaP" Total="Sum" Caption="Zmniejszenia (P)" Format="{0:n}" ID="colZmniejszeniaWartoscP" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscBruttoB" Total="Sum" Caption="Wartość (B)" Format="{0:n}" ID="colWartoscB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscBruttoP" Total="Sum" Caption="Wartość (P)" Format="{0:n}" ID="colWartoscP" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="OdpisyAktualizujaceB" Total="Sum" Caption="Odpisy aktualizujące (B)" Format="{0:n}" ID="colOdpisyAktualizujaceB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="OdpisyAktualizujaceP" Total="Sum" Caption="Odpisy aktualizujące (P)" Format="{0:n}" ID="colOdpisyAktualizujaceP" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Odpisy01B" Total="Sum" Caption="Umorzenie na 01.01.br (B)" Format="{0:n}" ID="colOdpisy01B" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Odpisy01P" Total="Sum" Caption="Umorzenie na 01.01.br (P)" Format="{0:n}" ID="colOdpisy01P" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="OdpisyZwiekszeniaB" Total="Sum" Caption="Umorzenia bieżące (B)" Format="{0:n}" ID="colZwiekszeniaOdpisyB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="OdpisyZwiekszeniaP" Total="Sum" Caption="Umorzenia bieżące (P)" Format="{0:n}" ID="colZwiekszeniaOdpisyP" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="OdpisyZmniejszeniaB" Total="Sum" Caption="Korekty umorzeń (B)" Format="{0:n}" ID="colZmniejszeniaOdpisyB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="OdpisyZmniejszeniaP" Total="Sum" Caption="Korekty umorzeń (P)" Format="{0:n}" ID="colZmniejszeniaOdpisyP" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="OdpisyB" Total="Sum" Caption="Umorzenie (B)" Format="{0:n}" ID="colOdpisyB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="OdpisyP" Total="Sum" Caption="Umorzenie (P)" Format="{0:n}" ID="colOdpisyP" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscNettoB" Total="Sum" Caption="Wartość netto (B)" Format="{0:n}" ID="colWartoscNettoB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="WartoscNettoP" Total="Sum" Caption="Wartość netto (P)" Format="{0:n}" ID="colWartoscNettoP" runat="server"></ea:GridColumn>
</Columns>
			</ea:Grid><BR>
			</ea:DataRepeater>
			<cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

